\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{inred-upv}[2022/12/01 Editorial de la Universitat Politecnica de Valencia]
\LoadClass[10pt,onecolumn]{article}

\RequirePackage[spanish,es-tabla]{babel}
\renewcommand{\spanishfigurename}{Fig.}

%\RequirePackage{mathptmx} % Times

\RequirePackage[table]{xcolor}
\RequirePackage{tikz}

% ------------------------------------------------------

\RequirePackage{ifthen}

% ------------------------------------------------------

\newboolean{valencia}\setboolean{valencia}{false}
\newboolean{castellano}\setboolean{castellano}{false}
\newboolean{english}\setboolean{english}{false}
\newboolean{distanciesEquacions}\setboolean{distanciesEquacions}{true}

% ------------------------------------------------------

\DeclareOption{nomathskip}{\setboolean{distanciesEquacions}{false}}

\DeclareOption{valencia}{%
	\setboolean{valencia}{true}
	\setboolean{castellano}{false}
	\setboolean{english}{false}
	}
\DeclareOption{castellano}{%
	\setboolean{valencia}{false}
	\setboolean{castellano}{true}
	\setboolean{english}{false}
	}
\DeclareOption{english}{%
	\setboolean{valencia}{false}
	\setboolean{castellano}{false}
	\setboolean{english}{true}
	}

% ------------------------------------------------------

\DeclareOption*{\ClassWarning{inred-upv}{No podem processar l'opci\'{o}: ?\CurrentOption?}}

% ------------------------------------------------------

\ExecuteOptions{}
\ProcessOptions\relax

% ------------------------------------------------------

\RequirePackage{graphicx}
\RequirePackage{calc}
%\RequirePackage{hyperref}


% ------------------------------------------------------

\newcommand{\AnyInred}{2024}
\newcommand{\DatesInred}{11 -- 12 de julio}
\newcommand{\numRomaCongres}{X}


\newcommand{\tituloPonenciaEncabezadoInterno}{}

\newcommand{\tituloPonenciaEncabezado}[2]{%
	\renewcommand{\tituloPonenciaEncabezadoInterno}{#1}%
	}

\newcommand{\tituloPonencia}[2]{%
	\ifthenelse{\equal{\tituloPonenciaEncabezadoInterno}{}}
		{\renewcommand{\tituloPonenciaEncabezadoInterno}{#1}}
		{}
	\title{\vspace*{1cm}#1#2}%
	}

%\def\and{~\\[1ex]}
%\def\and{, }

\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage
  \null
  \vskip -1em%
  %\begin{center}%
  \let \footnote \thanks
    {\raggedright\bfseries\Large \@title \par}%
    \vskip 1.5em%
    {\normalsize\bfseries
      \lineskip .25em%
      \begin{tabular}[t]{@{}l}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
%    {\large \@date}%
  %\end{center}%
  \par
  \vskip -1.25em
  
  \centering
  \fboxsep=6pt
  \newlength{\ampleHowToCite}\setlength{\ampleHowToCite}{\textwidth-12pt}
  \fcolorbox{black!10}{black!10}{%
	\parbox{\ampleHowToCite}{%
		\textbf{How to cite}: \autoresParaEncabezado. \AnyInred.
		\tituloPonenciaEncabezadoInterno. 
		En libro de actas: \textit{\numRomaCongres Congreso de Innovacin Educativa y Docencia en Red}. Valencia, \DatesInred\ de \AnyInred. Doi: \doiEncabezado.
	}}

  \par
  \vskip +2.0em
  
  }
  
%Inicial Nombre Autor, Inicial Nombre Autor y Inicial Nombre Autor. 2024. Ttulo de la Comunicacin. En libro de actas: X Congreso de Innovacin Educativa y Docencia en Red. Valencia, 11 - 12 de julio de 2024. Doi:
  
  

% ---------------------------------------------------------------------
% Tipo de letra

\renewcommand{\normalsize}{\fontsize{10pt}{12pt}\selectfont}
\renewcommand{\familydefault}{\rmdefault}
	

% ---------------------------------------------------------------------
% Formato de pgina

\RequirePackage{geometry}


\geometry{ 
	a4paper, twoside,         	
	hmargin={3cm,3cm},
	vmargin={3cm,3cm},
	includehead, includefoot, 	
	headsep = 0.75cm,          	
	footskip = 1.75cm,        	
	footnotesep = 1.0cm,
	}

% ---------------------------------------------------------------------
% Encabezados y pies de pgina

\newcommand{\autoresEncabezado}[1]{\newcommand{\autoresParaEncabezado}{#1}}
\newcommand{\notaCopyright}[1]{\newcommand{\notaCopyrightPie}{#1}}
\newcommand{\tituloCongreso}[1]{\newcommand{\tituloCongresoEncabezado}{#1}}
\newcommand{\logoCongreso}[1]{\newcommand{\logoCongresoEncabezado}{#1}}
\newcommand{\doi}[1]{
	\ifdefined\doiEncabezado
		\renewcommand{\doiEncabezado}{#1}
	\else
		\newcommand{\doiEncabezado}{#1}
	\fi
	}		
%\doi{http://dx.doi.org/10.4995/INRED\AnyInred.\AnyInred.****}
\doi{}
\newcommand{\recibido}[1]{\newcommand{\recibidoEncabezado}{#1}}
\newcommand{\aceptado}[1]{\newcommand{\aceptadoEncabezado}{#1}}

%\RequirePackage{lastpage}

\RequirePackage{fancyhdr}
\pagestyle{fancy}

\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}{}}

\fancyhf{} % clear all header and footer fields 

\fancyhead[CE]{\small\itshape\nouppercase\tituloPonenciaEncabezadoInterno}
\fancyhead[CO]{%
	\ifdefined\autoresParaEncabezado
		\small\itshape\nouppercase\autoresParaEncabezado
	\else
		\small\bfseries\nouppercase ATENCI\'ON: Se debe usar el comando \texttt{\textbackslash autoresEncabezado\{\}}
	\fi
	}

\fancyfoot[C]{%
	\ifdefined\notaCopyrightPie
		\small\notaCopyrightPie%: \thepage--\pageref*{LastPage}\\[0.5ex]
	\fi
	}	

\fancypagestyle{plain}{% 
    \fancyhf{} % clear all header and footer fields 
	\fancyhead[R]{\tituloCongresoEncabezado%\\
%		\ifdefined\doiEncabezado
%			Doi: \href{\doiEncabezado}{\sffamily\doiEncabezado}%\\[2.5ex]
%		\fi
		}
	\fancyhead[L]{%
		\ifdefined\logoCongresoEncabezado
			\logoCongresoEncabezado%
		\fi
		\ifdefined\recibidoEncabezado
			\vspace{2ex}
			{\footnotesize\itshape
			Recibido: \recibidoEncabezado}\\
		\fi
		\ifdefined\aceptadoEncabezado
			{\footnotesize\itshape
			Aceptado: \aceptadoEncabezado}\\
		\fi
		}
	\fancyfoot[C]{\small%
	\ifdefined\notaCopyrightPie
		\small\notaCopyrightPie%
	\fi
	}	
    \renewcommand{\headrulewidth}{0pt} 
    \renewcommand{\footrulewidth}{0pt}
	}

\renewcommand{\headrulewidth}{0.0pt}
\renewcommand{\footrulewidth}{0.0pt}


% ---------------------------------------------------------------------
% Formato de prrafo y maquetacin

\setlength{\parskip}{2ex}
\setlength{\parindent}{0pt}

\linespread{1.0}

\setlength{\widowpenalty}{10000pt}
\setlength{\clubpenalty}{10000pt}

\raggedbottom

% ---------------------------------------------------------------------
% Mejora los ttulos de las figuras y tablas

\RequirePackage{caption}

\captionsetup{font=footnotesize}
\captionsetup[figure]{labelfont=it,textfont=it}
\captionsetup[table]{labelfont=it,textfont=it}

% ------------------------------------------------------------------------
% Formato de las secciones

\RequirePackage[
	raggedright,
	compact,
	nobottomtitles*, % Evita que queden ttols solts al final de la pgina
	clearempty, % Modifica \cleardoublepage per a que els fulls parells buides siguen blanques
	]{titlesec}

% ------------------------------------------------------------------------

\titleformat{\section}
	[hang]
	{\vspace{2ex}\raggedright\tolerance=10000\hyphenpenalty=10000}
	{\fontsize{13}{15}\bfseries\thesection}
	{.75em}
	{\fontsize{13}{15}\bfseries}

% ------------------------------------------------------------------------

\titleformat{\subsection}
	[hang]
	{\vspace{1.5ex}\raggedright\tolerance=10000\hyphenpenalty=10000}
	{\fontsize{10}{12}\bfseries\thesubsection}
	{.5em}
	{\fontsize{10}{12}\bfseries}
	[\vspace{-1ex}]

% ------------------------------------------------------------------------

\titleformat{\subsubsection}
	[hang]
	{\vspace{2ex}\raggedright\tolerance=10000\hyphenpenalty=10000}
	{\normalsize\itshape\thesubsubsection}
	{.5em}
	{\normalsize\itshape}
	[\vspace{-0.75ex}]


% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------

\RequirePackage{enumitem}
\setlist[1]{partopsep=-1ex,parsep=\parskip,itemsep=0\parskip}
\setlist[2]{partopsep=-1ex,parsep=\parskip,itemsep=0\parskip}


% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------

\renewenvironment{abstract}
{
\if@twocolumn\else\vspace{-5ex}\begin{quote}\fi
\rule{\linewidth}{0.2pt}\\[0ex]
\itshape\textbf{Abstract}

}
{
\if@twocolumn\else\end{quote}\fi
}

\newenvironment{resumen}
{
\if@twocolumn\vspace{0ex}\else\vspace{-5ex}\begin{quote}\fi
\rule{\linewidth}{0.2pt}\\
\itshape\textbf{Resumen}

}
{
%\rule{\linewidth}{0.2pt}\\[1ex]
\if@twocolumn\vspace{1ex}\else\end{quote}\vspace{0ex}\fi
}

\newcommand{\keywords}{\textbf{Keywords}}


% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------

% authblk.sty

\newcommand\Authfont{\bfseries}
\newcommand\Affilfont{\normalfont}
\newcommand\Authsep{, }
\newcommand\Authands{, and }
\newcommand\Authand{ and }
\newlength{\affilsep}\setlength{\affilsep}{1em}
\newlength{\@affilsep}
\newcounter{Maxaffil}
\setcounter{Maxaffil}{2}
%\DeclareOption{blocks}{\setcounter{Maxaffil}{\maxdimen}}
%\DeclareOption{noblocks}{\setcounter{Maxaffil}{0}}
%\DeclareOption{max2}{\setcounter{Maxaffil}{2}}
%\DeclareOption{max3}{\setcounter{Maxaffil}{3}}
%\DeclareOption{max4}{\setcounter{Maxaffil}{4}}
%\DeclareOption{max5}{\setcounter{Maxaffil}{5}}
%\DeclareOption{max6}{\setcounter{Maxaffil}{6}}
%\DeclareOption{auth-sc}{\renewcommand\Authfont{\scshape}}
%\DeclareOption{auth-sc-lg}{\renewcommand\Authfont{\large\scshape}}
%\DeclareOption{auth-lg}{\renewcommand\Authfont{\large}}
%\DeclareOption{affil-sl}{\renewcommand\Affilfont{\slshape}}
%\DeclareOption{affil-it}{\renewcommand\Affilfont{\itshape}}
%\DeclareOption{german}{\renewcommand\Authand{, und }%
%                       \renewcommand\Authands{, und }}
%\ProcessOptions
\newcounter{authors}
\newcounter{affil}
\newif\ifnewaffil \newaffiltrue
\newcommand\AB@authnote[1]{\textsuperscript{\normalfont#1}}
\newcommand\AB@affilnote[1]{\textsuperscript{\normalfont#1}}
\providecommand\textsuperscript[1]{$^{#1}$}
\newcommand\AB@blk@and{\protect\Authfont\protect\AB@setsep}
\newcommand\AB@pand{\protect\and \protect\Authfont \protect\AB@setsep}
\@namedef{@sep1}{}
\@namedef{@sep2}{\Authand}
\newcommand\AB@affilsep{\protect\Affilfont}
\newcommand\AB@affilsepx{\protect\\\protect\Affilfont}
\newcommand\AB@setsep{\setlength{\@affilsep}{\affilsep}}
\newcommand\AB@resetsep{\setlength{\@affilsep}{\z@}}
\newcommand\AB@authlist{}
\newcommand\AB@affillist{}
\newcommand\AB@authors{}
\newcommand\AB@empty{}
\xdef\AB@author{\noexpand\AB@blk@and\@author}
\renewcommand\author[2][]%
      {\ifnewaffil\addtocounter{affil}{1}%
       \edef\AB@thenote{\arabic{affil}}\fi
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \ifnum\value{authors}>1\relax
      \@namedef{@sep\number\c@authors}{\Authsep}\fi
      \addtocounter{authors}{1}%
      \begingroup
          \let\protect\@unexpandable@protect \let\and\AB@pand
          \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
         \@temptokena=\expandafter{\AB@authors}%
         {\def\\{\protect\\[\@affilsep]\protect\Affilfont
              \protect\AB@resetsep}%
              \xdef\AB@author{\AB@blk@and#2}%
       \ifnewaffil\gdef\AB@las{}\gdef\AB@lasx{\protect\Authand}\gdef\AB@as{}%
           \xdef\AB@authors{\the\@temptokena\AB@blk@and}%
       \else
          \xdef\AB@authors{\the\@temptokena\AB@as\AB@au@str}%
          \global\let\AB@las\AB@lasx\gdef\AB@lasx{\protect\Authands}%
          \gdef\AB@as{\Authsep}%
       \fi
       \gdef\AB@au@str{#2}}%
         \@temptokena=\expandafter{\AB@authlist}%
         \let\\=\authorcr
         \xdef\AB@authlist{\the\@temptokena
           \protect\@nameuse{@sep\number\c@authors}%
           \protect\Authfont#2\AB@authnote{\AB@note}}%
      \endgroup
      \ifnum\value{authors}>2\relax
      \@namedef{@sep\number\c@authors}{\Authands}\fi
      \newaffilfalse
}
\newcommand\authorcr{\protect\\ \protect\Authfont \protect\AB@setsep}%
\newcommand\affil[2][]%
   {\newaffiltrue\let\AB@blk@and\AB@pand
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \begingroup
        \let\protect\@unexpandable@protect
        \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
        \@temptokena=\expandafter{\AB@authors}%
        {\def\\{\protect\\\protect\Affilfont}\xdef\AB@temp{#2}}%
         \xdef\AB@authors{\the\@temptokena\AB@las\AB@au@str
         \protect\\[\affilsep]\protect\Affilfont\AB@temp}%
         \gdef\AB@las{}\gdef\AB@au@str{}%
        {\def\\{, \ignorespaces}\xdef\AB@temp{#2}}%
        \@temptokena=\expandafter{\AB@affillist}%
        \xdef\AB@affillist{\the\@temptokena \AB@affilsep
          \AB@affilnote{\AB@note}\protect\Affilfont\AB@temp}%
      \endgroup
       \let\AB@affilsep\AB@affilsepx
}
\def\@author{}
\renewcommand\@author{\ifx\AB@affillist\AB@empty\AB@author\else
      \ifnum\value{affil}>\value{Maxaffil}\def\rlap##1{##1}%
    \AB@authlist\\[\affilsep]\AB@affillist
    \else  \AB@authors\fi\fi}
\let\AB@maketitle=\maketitle
\def\maketitle
  {{\renewenvironment{tabular}[2][]{\begin{flushleft}}
                                   {\end{flushleft}}
  \AB@maketitle}}

%\RequirePackage[blocks]{authblk}
\renewcommand\Authsep{, } 
\renewcommand\Authand{ y } 
\renewcommand\Authands{ y }


% -------------------------------------------------------
% -------------------------------------------------------
% -------------------------------------------------------
% Informacin del congreso

\logoCongreso{%
	\tikz\node[overlay,below right, yshift=3.5mm]{
		\includegraphics[
			trim=0.85cm 0cm 0cm 0cm, clip,
			width=5.5cm
			]{logos/Logo_IN-RED}%
		};%
	}

\tituloCongreso{%
	\tikz\node[overlay,below left, yshift=2mm]{%
		\parbox{.5\textwidth}{\raggedleft%
			\scriptsize\sffamily%
			Congreso In-Red \AnyInred\\[0.5ex]
			UPV, \DatesInred\ de \AnyInred%
			\ifdefined\doiEncabezado\\[1ex]
				Doi: \href{\doiEncabezado}{\sffamily\doiEncabezado}%\\[2.5ex]
			\fi
			}
		};
	}
	
\notaCopyright{%
	\tikz\node[overlay, above, yshift=0mm]{%
		\parbox{\textwidth}{\centering%
			\href{http://creativecommons.org}{\includegraphics[width=1.5cm]{logos/nota_copyright}}\ %
			\footnotesize
			\raisebox{.65ex}{ \AnyInred, Universitat Polit{\`e}cnica de Val{\`e}ncia}\\%
			\itshape Congreso In-Red (\AnyInred)
			}
		};
	}


% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------


\RequirePackage{mathtools}

\ifdistanciesEquacions

	\AtBeginDocument
	% ---------------------------------------------------
	% Distncies de les equacions al text
	
	% Per a les equacions normals
	\abovedisplayshortskip = -1.0ex plus 0ex minus 0.25ex
	\belowdisplayshortskip = 2.0ex plus 1ex minus 0.0ex
	
	% Per a les equacions en varies lnies
	\abovedisplayskip = -1.0ex plus 0ex minus 0.25ex
	\belowdisplayskip = 2.0ex plus 1ex minus 0.0ex	

\else

	\AtBeginDocument

\fi

%\iftwocolumn\twocolumn\fi


% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
% ------------------------------------------------------------------------
